<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Dashboard | AONMED</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body { background:#f5f6f7; }
        .nav-tabs .nav-link { font-size:14px; font-weight:500; }
        .table th { font-size:12px; text-transform:uppercase; }
        .table td { font-size:14px; }
        .section-title { font-size:15px; font-weight:600; }
    </style>

    <script>
        let lat=null,lng=null;
        window.onload=()=>navigator.geolocation?.getCurrentPosition(p=>{
            lat=p.coords.latitude; lng=p.coords.longitude;
        });
    </script>
</head>
<body>

<!-- NAVBAR -->
<nav class="navbar navbar-expand-lg navbar-light bg-white border-bottom">
    <div class="container-fluid">

        <!-- BRAND -->
        <a class="navbar-brand fw-bold" href="<?php echo e(route('dashboard')); ?>">
            AONMED HR System
        </a>

        <!-- MOBILE TOGGLER -->
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar">
            <span class="navbar-toggler-icon"></span>
        </button>

        <!-- NAV CONTENT -->
        <div class="collapse navbar-collapse" id="mainNavbar">

            <!-- LEFT LINKS -->
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <li class="nav-item">
                    <a class="nav-link <?php echo e(request()->routeIs('dashboard') ? 'active fw-semibold' : ''); ?>"
                       href="<?php echo e(route('dashboard')); ?>">
                        Dashboard
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link <?php echo e(request()->is('employees*') ? 'active fw-semibold' : ''); ?>"
                       href="<?php echo e(route('users.index')); ?>">
                        Employees
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link <?php echo e(request()->is('leave*') ? 'active fw-semibold' : ''); ?>"
                       href="<?php echo e(route('leave.index')); ?>">
                        Leave
                    </a>
                </li>
            </ul>

            <!-- RIGHT USER INFO -->
            <div class="d-flex align-items-center gap-3">
                <span class="small text-muted">
                    <?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?>

                </span>

                <form method="POST" action="<?php echo e(route('logout')); ?>">
                    <?php echo csrf_field(); ?>
                    <button class="btn btn-sm btn-outline-secondary">
                        Logout
                    </button>
                </form>
            </div>

        </div>
    </div>
</nav>


<div class="container mt-4">

    <h4 class="fw-semibold">Dashboard</h4>
    <p class="text-muted small"><?php echo e($user->department); ?> Department</p>

    <!-- SUCCESS MESSAGES -->
    <?php $__currentLoopData = ['success','success_report','success_payroll','success_sales']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if(session($msg)): ?>
            <div class="alert alert-success alert-dismissible fade show small">
                <?php echo e(session($msg)); ?>

                <button class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <!-- TABS -->
    <ul class="nav nav-tabs mt-3">
        <li class="nav-item">
            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#attendance">Attendance</button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#reports">Reports</button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#payroll">Payroll</button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#sales">Sales & Purchases</button>
        </li>
    </ul>

    <div class="tab-content bg-white border border-top-0 p-4">

        <!-- ATTENDANCE -->
        <div class="tab-pane fade show active" id="attendance">
            <div class="row g-3 mb-4">
                <div class="col-md-6">
                    <form method="POST" action="<?php echo e(route('attendance.clock-in')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="lat" id="latIn">
                        <input type="hidden" name="lng" id="lngIn">
                        <button class="btn btn-success w-100"
                            <?php if($attendance && $attendance->clock_in): ?> disabled <?php endif; ?>>
                            Clock In
                        </button>
                    </form>
                </div>

                <div class="col-md-6">
                    <form method="POST" action="<?php echo e(route('attendance.clock-out')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="lat" id="latOut">
                        <input type="hidden" name="lng" id="lngOut">
                        <button class="btn btn-danger w-100"
                            <?php if(!$attendance || !$attendance->clock_in || $attendance->clock_out): ?> disabled <?php endif; ?>>
                            Clock Out
                        </button>
                    </form>
                </div>
            </div>

            <div class="section-title mb-2">Attendance History</div>

            <table class="table table-sm table-striped">
                <thead>
                    <tr>
                        <th>Date</th><th>Clock In</th><th>Clock Out</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $attendanceHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($row->created_at->format('d M Y')); ?></td>
                            <td><?php echo e($row->clock_in ?? '-'); ?></td>
                            <td><?php echo e($row->clock_out ?? '-'); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="3" class="text-center text-muted">No records</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- REPORTS -->
        <div class="tab-pane fade" id="reports">
            <div class="d-flex justify-content-between mb-3">
                <div class="section-title">My Reports</div>
                <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#reportModal">
                    New Report
                </button>
            </div>

            <table class="table table-sm table-hover">
                <thead>
                    <tr>
                        <th>Type</th><th>Remarks</th><th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($r->type); ?></td>
                            <td><?php echo e($r->remarks ?? '-'); ?></td>
                            <td><?php echo e($r->created_at->format('d M Y')); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="3" class="text-center text-muted">No reports</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- PAYROLL -->
        <div class="tab-pane fade" id="payroll">
            <div class="d-flex justify-content-between mb-3">
                <div class="section-title">Payroll Submissions</div>
                <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#payrollModal">
                    Submit Payroll
                </button>
            </div>

            <table class="table table-sm table-bordered">
                <thead>
                    <tr>
                        <th>Remarks</th><th>Status</th><th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $payrolls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($p->remarks ?? '-'); ?></td>
                            <td>
                                <span class="badge bg-<?php echo e($p->approved_by ? 'success':'warning'); ?>">
                                    <?php echo e($p->approved_by ? 'Approved':'Pending'); ?>

                                </span>
                            </td>
                            <td><?php echo e($p->created_at->format('d M Y')); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="3" class="text-center text-muted">No payrolls</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- SALES -->
        <div class="tab-pane fade" id="sales">
            <div class="d-flex justify-content-between mb-3">
                <div class="section-title">Sales & Purchase Requests</div>
                <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#salesModal">
                    New Request
                </button>
            </div>

            <table class="table table-sm table-hover">
                <thead>
                    <tr>
                        <th>Type</th><th>Remarks</th><th>Status</th><th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $salesRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="text-capitalize"><?php echo e($s->type); ?></td>
                            <td><?php echo e($s->remarks ?? '-'); ?></td>
                            <td>
                                <span class="badge bg-<?php echo e($s->approved_by ? 'success':'warning'); ?>">
                                    <?php echo e($s->approved_by ? 'Approved':'Pending'); ?>

                                </span>
                            </td>
                            <td><?php echo e($s->created_at->format('d M Y')); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="4" class="text-center text-muted">No requests</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

    </div>
</div>

<!-- ================= MODALS ================= -->

<!-- REPORT MODAL -->
<div class="modal fade" id="reportModal">
    <div class="modal-dialog">
        <form method="POST" action="<?php echo e(route('reports.submit')); ?>" enctype="multipart/form-data" class="modal-content">
            <?php echo csrf_field(); ?>
            <div class="modal-header"><h6 class="modal-title">Submit Report</h6></div>
            <div class="modal-body">
                <input name="type" class="form-control mb-2" placeholder="Report type" required>
                <input type="file" name="file" class="form-control mb-2" required>
                <textarea name="remarks" class="form-control" placeholder="Remarks"></textarea>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cancel</button>
                <button class="btn btn-primary btn-sm">Submit</button>
            </div>
        </form>
    </div>
</div>

<!-- PAYROLL MODAL -->
<div class="modal fade" id="payrollModal">
    <div class="modal-dialog">
        <form method="POST" action="<?php echo e(route('payrolls.submit')); ?>" enctype="multipart/form-data" class="modal-content">
            <?php echo csrf_field(); ?>
            <div class="modal-header"><h6 class="modal-title">Submit Payroll</h6></div>
            <div class="modal-body">
                <input type="file" name="file" class="form-control mb-2" required>
                <textarea name="remarks" class="form-control" placeholder="Remarks"></textarea>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cancel</button>
                <button class="btn btn-primary btn-sm">Submit</button>
            </div>
        </form>
    </div>
</div>

<!-- SALES MODAL -->
<div class="modal fade" id="salesModal">
    <div class="modal-dialog">
        <form method="POST" action="<?php echo e(route('sales-purchase-requests.submit')); ?>" enctype="multipart/form-data" class="modal-content">
            <?php echo csrf_field(); ?>
            <div class="modal-header"><h6 class="modal-title">Sales / Purchase Request</h6></div>
            <div class="modal-body">
                <select name="type" class="form-select mb-2" required>
                    <option disabled selected>Select type</option>
                    <option value="sale">Sale</option>
                    <option value="purchase">Purchase</option>
                </select>
                <input type="file" name="file" class="form-control mb-2" required>
                <textarea name="remarks" class="form-control" placeholder="Remarks"></textarea>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cancel</button>
                <button class="btn btn-primary btn-sm">Submit</button>
            </div>
        </form>
    </div>
</div>

<script>
    document.querySelector('form[action="<?php echo e(route("attendance.clock-in")); ?>"]')
        ?.addEventListener('submit',()=>{latIn.value=lat;lngIn.value=lng});
    document.querySelector('form[action="<?php echo e(route("attendance.clock-out")); ?>"]')
        ?.addEventListener('submit',()=>{latOut.value=lat;lngOut.value=lng});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH /Users/value8/Documents/work/skills_dev/aon/resources/views/dashboard/index.blade.php ENDPATH**/ ?>