<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>User Management</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-light bg-white border-bottom">
    <div class="container-fluid">

        <!-- BRAND -->
        <a class="navbar-brand fw-bold" href="<?php echo e(route('dashboard')); ?>">
            AONMED HR System
        </a>

        <!-- MOBILE TOGGLER -->
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar">
            <span class="navbar-toggler-icon"></span>
        </button>

        <!-- NAV CONTENT -->
        <div class="collapse navbar-collapse" id="mainNavbar">

            <!-- LEFT LINKS -->
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <li class="nav-item">
                    <a class="nav-link <?php echo e(request()->routeIs('dashboard') ? 'active fw-semibold' : ''); ?>"
                       href="<?php echo e(route('dashboard')); ?>">
                        Dashboard
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link <?php echo e(request()->is('employees*') ? 'active fw-semibold' : ''); ?>"
                       href="<?php echo e(route('users.index')); ?>">
                        Employees
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link <?php echo e(request()->is('leave*') ? 'active fw-semibold' : ''); ?>"
                       href="<?php echo e(route('leave.index')); ?>">
                        Leave
                    </a>
                </li>
            </ul>

            <!-- RIGHT USER INFO -->
            <div class="d-flex align-items-center gap-3">
                <span class="small text-muted">
                    <?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?>

                </span>

                <form method="POST" action="<?php echo e(route('logout')); ?>">
                    <?php echo csrf_field(); ?>
                    <button class="btn btn-sm btn-outline-secondary">
                        Logout
                    </button>
                </form>
            </div>

        </div>
    </div>
</nav>

<div class="container mt-4">

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#addUserModal">
        Add User
    </button>

    <table class="table table-bordered table-striped">
        <thead>
        <tr>
            <th>Name</th>
            <th>Email</th>
            <th>Department</th>
            <th>Status</th>
            <th width="280">Actions</th>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr class="<?php echo e($user->employment_status ? '' : 'table-danger'); ?>">
                <td><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></td>
                <td><?php echo e($user->email); ?></td>
                <td><?php echo e($user->department); ?></td>
                <td><?php echo e($user->employment_status ? 'Active' : 'Inactive'); ?></td>
                <td class="d-flex gap-1">

                    <button
                        class="btn btn-sm btn-warning"
                        data-bs-toggle="modal"
                        data-bs-target="#editUserModal<?php echo e($user->id); ?>">
                        Edit
                    </button>

                    <form method="POST" action="<?php echo e(route('users.toggle', $user)); ?>">
                        <?php echo csrf_field(); ?>
                        <button class="btn btn-sm btn-secondary">
                            <?php echo e($user->employment_status ? 'Deactivate' : 'Activate'); ?>

                        </button>
                    </form>

                    <form method="POST" action="<?php echo e(route('users.reset.password', $user)); ?>">
                        <?php echo csrf_field(); ?>
                        <button class="btn btn-sm btn-danger">
                            Reset Password
                        </button>
                    </form>
                </td>
            </tr>

            <!-- ================= EDIT USER MODAL ================= -->
            <div class="modal fade" id="editUserModal<?php echo e($user->id); ?>" tabindex="-1">
                <div class="modal-dialog modal-lg">
                    <form method="POST" action="<?php echo e(route('users.update', $user)); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Edit User</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                            </div>

                            <div class="modal-body row g-3">

                                <div class="col-md-6">
                                    <label>First Name</label>
                                    <input type="text" name="first_name" class="form-control"
                                           value="<?php echo e($user->first_name); ?>" required>
                                </div>

                                <div class="col-md-6">
                                    <label>Last Name</label>
                                    <input type="text" name="last_name" class="form-control"
                                           value="<?php echo e($user->last_name); ?>" required>
                                </div>

                                <div class="col-md-6">
                                    <label>Phone</label>
                                    <input type="text" name="phone_number" class="form-control"
                                           value="<?php echo e($user->phone_number); ?>" required>
                                </div>

                                <div class="col-md-6">
                                    <label>Department</label>
                                    <input type="text" name="department" class="form-control"
                                           value="<?php echo e($user->department); ?>" required>
                                </div>

                            </div>

                            <div class="modal-footer">
                                <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                <button class="btn btn-primary">Update User</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>

<!-- ================= ADD USER MODAL ================= -->
<div class="modal fade" id="addUserModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <form method="POST" action="<?php echo e(route('users.store')); ?>">
            <?php echo csrf_field(); ?>

            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New User</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body row g-3">

                    <div class="col-md-6">
                        <label>First Name</label>
                        <input type="text" name="first_name" class="form-control" required>
                    </div>

                    <div class="col-md-6">
                        <label>Last Name</label>
                        <input type="text" name="last_name" class="form-control" required>
                    </div>

                    <div class="col-md-6">
                        <label>Email</label>
                        <input type="email" name="email" class="form-control" required>
                    </div>

                    <div class="col-md-6">
                        <label>Phone</label>
                        <input type="text" name="phone_number" class="form-control" required>
                    </div>

                    <div class="col-md-6">
                        <label>Gender</label>
                        <select name="gender" class="form-select" required>
                            <option value="">Select</option>
                            <option value="male">Male</option>
                            <option value="female">Female</option>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label>Date of Birth</label>
                        <input type="date" name="date_of_birth" class="form-control" required>
                    </div>

                    <div class="col-md-12">
                        <label>Department</label>
                        <input type="text" name="department" class="form-control" required>
                    </div>

                </div>

                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button class="btn btn-success">Create User</button>
                </div>
            </div>
        </form>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH /Users/value8/Documents/work/skills_dev/aon/resources/views/admin/users/index.blade.php ENDPATH**/ ?>