<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Login | AONMED</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            background-color: #f5f6f7;
        }

        .auth-wrapper {
            min-height: 100vh;
        }

        .auth-card {
            background: #ffffff;
            border: 1px solid #dee2e6;
            border-radius: 6px;
        }

        .auth-header {
            padding: 1.5rem;
            text-align: center;
            border-bottom: 1px solid #dee2e6;
        }

        .auth-header img {
            height: 45px;
            margin-bottom: 10px;
        }

        .auth-header h6 {
            margin: 0;
            font-weight: 600;
            color: #212529;
        }

        .auth-body {
            padding: 1.75rem;
        }

        .auth-footer {
            padding: 0.75rem;
            text-align: center;
            font-size: 12px;
            color: #6c757d;
            border-top: 1px solid #dee2e6;
        }

        .form-label {
            font-size: 13px;
            font-weight: 500;
        }

        .form-control {
            font-size: 14px;
        }

        .btn-primary {
            font-size: 14px;
            padding: 0.5rem;
        }
    </style>
</head>
<body>

<div class="container auth-wrapper d-flex align-items-center justify-content-center">
    <div class="row w-100 justify-content-center">
        <div class="col-12 col-sm-10 col-md-6 col-lg-4">

            <div class="auth-card shadow-sm">

                <!-- Header -->
                <div class="auth-header">
                    <img src="<?php echo e(asset('images/aonmed-logo.png')); ?>" alt="AONMED Logo">
                    <h6>AONMED Staff Portal</h6>
                </div>

                <!-- Body -->
                <div class="auth-body">

                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger py-2 small">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div><?php echo e($error); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>

                    <form method="POST" action="<?php echo e(route('login.submit')); ?>">
                        <?php echo csrf_field(); ?>

                        <div class="mb-3">
                            <label class="form-label">Email or Employee Number</label>
                            <input type="text" name="login" class="form-control" required autofocus>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Password</label>
                            <input type="password" name="password" class="form-control" required>
                        </div>

                        <div class="d-grid mt-3">
                            <button class="btn btn-primary btn-sm">
                                Sign In
                            </button>
                        </div>
                    </form>

                    <div class="text-center mt-3">
                        <a href="<?php echo e(route('password.forgot')); ?>" class="small text-decoration-none">
                            Forgot password?
                        </a>
                    </div>

                </div>

                <!-- Footer -->
                <div class="auth-footer">
                    © <?php echo e(date('Y')); ?> AONMED. All rights reserved.
                </div>

            </div>

        </div>
    </div>
</div>

</body>
</html>
<?php /**PATH /Users/value8/Documents/work/skills_dev/aon/resources/views/auth/login.blade.php ENDPATH**/ ?>