<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Reset Password | AONMED</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            background-color: #f5f6f7;
        }

        .auth-wrapper {
            min-height: 100vh;
        }

        .auth-card {
            background: #ffffff;
            border: 1px solid #dee2e6;
            border-radius: 6px;
        }

        .auth-header {
            padding: 1.5rem;
            text-align: center;
            border-bottom: 1px solid #dee2e6;
        }

        .auth-header img {
            height: 45px;
            margin-bottom: 10px;
        }

        .auth-header h6 {
            margin: 0;
            font-weight: 600;
        }

        .auth-body {
            padding: 1.75rem;
        }

        .auth-footer {
            padding: 0.75rem;
            text-align: center;
            font-size: 12px;
            color: #6c757d;
            border-top: 1px solid #dee2e6;
        }

        .form-label {
            font-size: 13px;
            font-weight: 500;
        }

        .form-control {
            font-size: 14px;
        }
    </style>
</head>
<body>

<div class="container auth-wrapper d-flex align-items-center justify-content-center">
    <div class="row w-100 justify-content-center">
        <div class="col-12 col-sm-10 col-md-6 col-lg-4">

            <div class="auth-card shadow-sm">

                <!-- Header -->
                <div class="auth-header">
                    <img src="<?php echo e(asset('images/aonmed-logo.png')); ?>" alt="AONMED Logo">
                    <h6>Password Reset</h6>
                </div>

                <!-- Body -->
                <div class="auth-body">

                    <?php if(session('status')): ?>
                        <div class="alert alert-success small">
                            <?php echo e(session('status')); ?>

                        </div>
                    <?php endif; ?>

                    <form method="POST" action="<?php echo e(route('password.forgot.send')); ?>">
                        <?php echo csrf_field(); ?>

                        <div class="mb-3">
                            <label class="form-label">Registered Email Address</label>
                            <input type="email" name="email" class="form-control" required>
                        </div>

                        <div class="d-grid mt-3">
                            <button class="btn btn-primary btn-sm">
                                Send New Password
                            </button>
                        </div>
                    </form>

                    <div class="text-center mt-3">
                        <a href="<?php echo e(route('login')); ?>" class="small text-decoration-none">
                            Back to login
                        </a>
                    </div>

                </div>

                <!-- Footer -->
                <div class="auth-footer">
                    © <?php echo e(date('Y')); ?> AONMED
                </div>

            </div>

        </div>
    </div>
</div>

</body>
</html>
<?php /**PATH /Users/value8/Documents/work/skills_dev/aon/resources/views/auth/forgot-password.blade.php ENDPATH**/ ?>