<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\LeaveController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\PayrollController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AttendanceController;
use App\Http\Controllers\UserManagementController;
use App\Http\Controllers\SalesPurchaseRequestController;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/', fn () => view('auth.login'))->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.submit');
Route::get('/forgot-password', [AuthController::class, 'show'])->name('password.forgot');
Route::post('/forgot-password', [AuthController::class, 'send'])->name('password.forgot.send');

Route::middleware(['auth', 'prevent-back-history'])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

    Route::get('/profile', [ProfileController::class, 'index'])->name('profile.index');
    Route::post('/profile/password', [ProfileController::class, 'changePassword'])->name('profile.password');

    Route::post('/attendance/clock-in', [AttendanceController::class, 'clockIn'])->name('attendance.clock-in');
    Route::post('/attendance/clock-out', [AttendanceController::class, 'clockOut'])->name('attendance.clock-out');

    Route::post('/reports/submit', [ReportController::class, 'submit'])->name('reports.submit');

    Route::post('/payrolls/submit', [PayrollController::class, 'submit'])->name('payrolls.submit');

    Route::post('/sales-purchase-requests/submit', [SalesPurchaseRequestController::class, 'submit'])->name('sales-purchase-requests.submit');

    Route::get('/leave', [LeaveController::class, 'index'])->name('leave.index');
    Route::post('/leave/apply', [LeaveController::class, 'apply'])->name('leave.apply');

    Route::get('/admin/dashboard', [AdminController::class, 'index'])->name('admin.dashboard');

    Route::post('/admin/action', [AdminController::class, 'action'])->name('admin.action');
    //Route::post('/leave/approval/{leaveRequest}/action', [AdminController::class, 'action'])->name('leave.approval.action');

    Route::get('/admin/users', [UserManagementController::class, 'index'])->name('users.index');
    Route::get('/admin/users/create', [UserManagementController::class, 'create'])->name('users.create');
    Route::post('/admin/users', [UserManagementController::class, 'store'])->name('users.store');
    Route::get('/admin/users/{user}/edit', [UserManagementController::class, 'edit'])->name('users.edit');
    Route::put('/admin/users/{user}', [UserManagementController::class, 'update'])->name('users.update');
    Route::post('/admin/users/{user}/toggle', [UserManagementController::class, 'toggleStatus'])->name('users.toggle');
    Route::post('/admin/users/{user}/reset-password', [UserManagementController::class, 'resetPassword'])->name('users.reset.password');
});
