<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>My Profile</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-light bg-white border-bottom">
    <div class="container-fluid">

        <!-- BRAND -->
        <a class="navbar-brand fw-bold" href="{{ route('dashboard') }}">
            AONMED HR System
        </a>

        <!-- MOBILE TOGGLER -->
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar">
            <span class="navbar-toggler-icon"></span>
        </button>

        <!-- NAV CONTENT -->
        <div class="collapse navbar-collapse" id="mainNavbar">

            <!-- LEFT LINKS -->
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('dashboard') ? 'active fw-semibold' : '' }}"
                       href="{{ route('dashboard') }}">
                        Dashboard
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link {{ request()->is('employees*') ? 'active fw-semibold' : '' }}"
                       href="{{ route('users.index') }}">
                        Employees
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link {{ request()->is('leave*') ? 'active fw-semibold' : '' }}"
                       href="{{ route('leave.index') }}">
                        Leave
                    </a>
                </li>
            </ul>

            <!-- RIGHT USER INFO -->
            <div class="d-flex align-items-center gap-3">
                <span class="small text-muted">
                    {{ $user->first_name }} {{ $user->last_name }}
                </span>

                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button class="btn btn-sm btn-outline-secondary">
                        Logout
                    </button>
                </form>
            </div>

        </div>
    </div>
</nav>

<div class="container mt-4" style="max-width: 600px">

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="card">
        <div class="card-header fw-bold">Change Password</div>
        <div class="card-body">

            <form method="POST" action="{{ route('profile.password') }}">
                @csrf

                <div class="mb-3">
                    <label class="form-label">Current Password</label>
                    <input type="password" name="current_password" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">New Password</label>
                    <input type="password" name="password" class="form-control" required minlength="8">
                </div>

                <div class="mb-3">
                    <label class="form-label">Confirm New Password</label>
                    <input type="password" name="password_confirmation" class="form-control" required>
                </div>

                <button class="btn btn-primary w-100">Update Password</button>
            </form>

        </div>
    </div>
</div>

</body>
</html>
