<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Leave Management | AON</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-light bg-white border-bottom">
    <div class="container-fluid">

        <!-- BRAND -->
        <a class="navbar-brand fw-bold" href="{{ route('dashboard') }}">
            AONMED HR System
        </a>

        <!-- MOBILE TOGGLER -->
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar">
            <span class="navbar-toggler-icon"></span>
        </button>

        <!-- NAV CONTENT -->
        <div class="collapse navbar-collapse" id="mainNavbar">

            <!-- LEFT LINKS -->
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('dashboard') ? 'active fw-semibold' : '' }}"
                       href="{{ route('dashboard') }}">
                        Dashboard
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link {{ request()->is('employees*') ? 'active fw-semibold' : '' }}"
                       href="{{ route('users.index') }}">
                        Employees
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link {{ request()->is('leave*') ? 'active fw-semibold' : '' }}"
                       href="{{ route('leave.index') }}">
                        Leave
                    </a>
                </li>
            </ul>

            <!-- RIGHT USER INFO -->
            <div class="d-flex align-items-center gap-3">
                <span class="small text-muted">
                    {{ $user->first_name }} {{ $user->last_name }}
                </span>

                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button class="btn btn-sm btn-outline-secondary">
                        Logout
                    </button>
                </form>
            </div>

        </div>
    </div>
</nav>

<div class="container mt-5">

    <h3>Leave Management</h3>
    <p class="text-muted">Track your leave balances and apply for leave</p>

    <!-- Success/Error Messages -->
{{-- Success message --}}
@if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif

{{-- Error message --}}
@if(session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
@endif

{{-- Validation errors --}}
@if($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif


    <div class="row g-4 mt-4">

        <!-- Leave Balances -->
        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5>Leave Balances</h5>
                    <ul class="list-group list-group-flush">
                        @foreach($leaveTypes as $type)
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                {{ $type->name }}
                                <span class="badge bg-primary rounded-pill">
                                    {{ $leaveBalances[$type->id]->balance_days ?? 0 }}
                                </span>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>

        <!-- Leave Request Form -->
        <div class="col-md-8">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5>Apply for Leave</h5>
                    <form method="POST" action="{{ route('leave.apply') }}" enctype="multipart/form-data">
                        @csrf

                        <div class="mb-3">
                            <label>Leave Type</label>
                            <select name="leave_type_id" class="form-control" required>
                                <option value="">Select Leave Type</option>
                                @foreach($leaveTypes as $type)
                                    <option value="{{ $type->id }}">{{ $type->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="row g-3 mb-3">
                            <div class="col">
                                <label>Start Date</label>
                                <input type="date" name="start_date" class="form-control" required>
                            </div>
                            <div class="col">
                                <label>End Date</label>
                                <input type="date" name="end_date" class="form-control" required>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label>Remarks</label>
                            <textarea name="reason" class="form-control" rows="2"></textarea>
                        </div>

                        <div class="mb-3">
                            <label>Attachment (optional)</label>
                            <input type="file" name="attachment" class="form-control" required>
                        </div>

                        <button type="submit" class="btn btn-primary">Submit Leave Request</button>
                    </form>
                </div>
            </div>
        </div>

    </div>

    <!-- Leave Requests Table -->
    <div class="row mt-5">
        <div class="col-md-12">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5>My Leave Requests</h5>
                    <table class="table table-bordered mt-3">
                        <thead>
                            <tr>
                                <th>Type</th>
                                <th>Start</th>
                                <th>End</th>
                                <th>Total Days</th>
                                <th>Status</th>
                                <th>Remarks</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($leaveRequests as $req)
                                <tr>
                                    <td>{{ $req->leaveType->name ?? 'N/A' }}</td>
                                    <td>{{ $req->start_date }}</td>
                                    <td>{{ $req->end_date }}</td>
                                    <td>{{ $req->total_days }}</td>
                                    <td>
                                        @if($req->status === 'approved')
                                            <span class="badge bg-success">Approved</span>
                                        @elseif($req->status === 'declined')
                                            <span class="badge bg-danger">Declined</span>
                                        @else
                                            <span class="badge bg-warning text-dark">Pending</span>
                                        @endif
                                    </td>
                                    <td>{{ $req->reason }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center">No leave requests yet.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
