<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Dashboard | Approvals</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css"
        rel="stylesheet"
    >
</head>
<body class="bg-light">

<nav class="navbar navbar-dark bg-dark px-4">
    <span class="navbar-brand mb-0 h1">Admin Approval Dashboard</span>
</nav>

<div class="container mt-4">

    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <ul class="nav nav-tabs" role="tablist">
        <li class="nav-item">
            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#leave">
                Leave Requests
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#payroll">
                Payroll
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#sales">
                Sales & Purchases
            </button>
        </li>
    </ul>

    <div class="tab-content mt-3">

        <!-- ================= LEAVE REQUESTS ================= -->
        <div class="tab-pane fade show active" id="leave">
            <div class="card">
                <div class="card-header fw-bold">Pending Leave Requests</div>
                <div class="card-body p-0">
                    <table class="table table-striped mb-0">
                        <thead>
                        <tr>
                            <th>Employee</th>
                            <th>Leave Type</th>
                            <th>Period</th>
                            <th>Days</th>
                            <th>Reason</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($leaveRequests as $leave)
                            <tr>
                                <td>
                                    {{ $leave->user->first_name }}
                                    {{ $leave->user->last_name }}
                                </td>
                                <td>{{ $leave->leaveType->name }}</td>
                                <td>
                                    {{ $leave->start_date }} → {{ $leave->end_date }}
                                </td>
                                <td>{{ $leave->total_days }}</td>
                                <td>{{ $leave->reason }}</td>
                                <td>
                                    <form method="POST" action="{{ route('admin.action') }}" class="d-flex gap-1">
                                        @csrf
                                        <input type="hidden" name="model" value="leave">
                                        <input type="hidden" name="id" value="{{ $leave->id }}">
                                        <button name="status" value="approved" class="btn btn-success btn-sm">
                                            Approve
                                        </button>
                                        <button name="status" value="declined" class="btn btn-danger btn-sm">
                                            Decline
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center text-muted p-3">
                                    No pending leave requests
                                </td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- ================= PAYROLL ================= -->
        <div class="tab-pane fade" id="payroll">
            <div class="card">
                <div class="card-header fw-bold">Pending Payroll Approvals</div>
                <div class="card-body p-0">
                    <table class="table table-striped mb-0">
                        <thead>
                        <tr>
                            <th>Employee</th>
                            <th>Document</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($payrolls as $payroll)
                            <tr>
                                <td>
                                    {{ $payroll->user->first_name }}
                                    {{ $payroll->user->last_name }}
                                </td>
                                <td>
                                    <a href="{{ asset('storage/'.$payroll->file) }}" target="_blank">
                                        View Payroll
                                    </a>
                                </td>
                                <td>
                                    <form method="POST" action="{{ route('admin.action') }}" class="d-flex gap-1">
                                        @csrf
                                        <input type="hidden" name="model" value="payroll">
                                        <input type="hidden" name="id" value="{{ $payroll->id }}">
                                        <button name="status" value="approved" class="btn btn-success btn-sm">
                                            Approve
                                        </button>
                                        <button name="status" value="declined" class="btn btn-danger btn-sm">
                                            Decline
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="text-center text-muted p-3">
                                    No pending payroll items
                                </td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- ================= SALES & PURCHASES ================= -->
        <div class="tab-pane fade" id="sales">
            <div class="card">
                <div class="card-header fw-bold">Pending Sales & Purchases</div>
                <div class="card-body p-0">
                    <table class="table table-striped mb-0">
                        <thead>
                        <tr>
                            <th>Employee</th>
                            <th>Type</th>
                            <th>Document</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($sales as $sale)
                            <tr>
                                <td>
                                    {{ $sale->user->first_name }}
                                    {{ $sale->user->last_name }}
                                </td>
                                <td>{{ $sale->type }}</td>
                                <td>
                                    <a href="{{ asset('storage/'.$sale->file) }}" target="_blank">
                                        View File
                                    </a>
                                </td>
                                <td>
                                    <form method="POST" action="{{ route('admin.action') }}" class="d-flex gap-1">
                                        @csrf
                                        <input type="hidden" name="model" value="sales">
                                        <input type="hidden" name="id" value="{{ $sale->id }}">
                                        <button name="status" value="approved" class="btn btn-success btn-sm">
                                            Approve
                                        </button>
                                        <button name="status" value="declined" class="btn btn-danger btn-sm">
                                            Decline
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-center text-muted p-3">
                                    No pending sales or purchases
                                </td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
