<?php

namespace Database\Seeders;

use App\Models\LeaveType;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class LeaveTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $leaveTypes = [

            [
                'name' => 'Annual Leave',
                'days_per_year' => 21,
                'calendar_days' => false, 
                'count_weekends' => false,
                'count_holidays' => false,
            ],

            [
                'name' => 'Sick Leave',
                'days_per_year' => 30,
                'calendar_days' => true,
                'count_weekends' => true,
                'count_holidays' => true,
            ],

            [
                'name' => 'Maternity Leave',
                'days_per_year' => 90,
                'calendar_days' => true,
                'count_weekends' => true,
                'count_holidays' => true,
            ],

            [
                'name' => 'Paternity Leave',
                'days_per_year' => 14,
                'calendar_days' => true,
                'count_weekends' => true,
                'count_holidays' => true,
            ],

            [
                'name' => 'Compassionate Leave',
                'days_per_year' => 5, 
                'calendar_days' => true,
                'count_weekends' => true,
                'count_holidays' => true,
            ],

        ];

        foreach ($leaveTypes as $leaveType) {
            LeaveType::updateOrCreate(
                ['name' => $leaveType['name']],
                $leaveType
            );
        }
    }
}
