<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\LeaveType;
use App\Models\LeaveBalance;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class LeaveBalanceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Leave balances definition
        $leaveConfig = [
            'Annual Leave'        => 21,
            'Sick Leave'          => 14,
            'Maternity Leave'     => 90, // female only
            'Paternity Leave'     => 14, // male only
            'Compassionate Leave' => 5,
        ];

        // Get all users
        $users = User::all();

        foreach ($users as $user) {

            foreach ($leaveConfig as $leaveName => $days) {

                // Gender rules
                if ($leaveName === 'Maternity Leave' && $user->gender !== 'female') {
                    continue;
                }

                if ($leaveName === 'Paternity Leave' && $user->gender !== 'male') {
                    continue;
                }

                $leaveType = LeaveType::where('name', $leaveName)->first();

                if (!$leaveType) {
                    continue;
                }

                LeaveBalance::updateOrCreate(
                    [
                        'user_id' => $user->id,
                        'leave_type_id' => $leaveType->id,
                    ],
                    [
                        'balance_days' => $days,
                    ]
                );
            }
        }

        $this->command->info('Leave balances seeded for all users (gender-aware).');
    }
}
