<?php

namespace Database\Seeders;

use App\Models\Holiday;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class HolidaySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $holidays = [
            // FIXED / RECURRING HOLIDAYS
            [
                'name' => 'New Year\'s Day',
                'date' => '2026-01-01',
                'is_recurring' => true,
                'month' => 1,
                'day' => 1,
            ],

            [
                'name' => 'Labour Day',
                'date' => '2026-05-01',
                'is_recurring' => true,
                'month' => 5,
                'day' => 1,
            ],

            [
                'name' => 'Madaraka Day',
                'date' => '2026-06-01',
                'is_recurring' => true,
                'month' => 6,
                'day' => 1,
            ],

            [
                'name' => 'Mashujaa Day',
                'date' => '2026-10-20',
                'is_recurring' => true,
                'month' => 10,
                'day' => 20,
            ],

            [
                'name' => 'Jamhuri Day',
                'date' => '2026-12-12',
                'is_recurring' => true,
                'month' => 12,
                'day' => 12,
            ],

            [
                'name' => 'Christmas Day',
                'date' => '2026-12-25',
                'is_recurring' => true,
                'month' => 12,
                'day' => 25,
            ],
            
            // VARIABLE / NON-RECURRING (2026)
            [
                'name' => 'Good Friday',
                'date' => '2026-04-03',
                'is_recurring' => false,
                'month' => null,
                'day' => null,
            ],

            [
                'name' => 'Easter Monday',
                'date' => '2026-04-06',
                'is_recurring' => false,
                'month' => null,
                'day' => null,
            ],

            [
                'name' => 'Idd-ul-Fitr',
                'date' => '2026-03-20',
                'is_recurring' => false,
                'month' => null,
                'day' => null,
            ],

            [
                'name' => 'Idd-ul-Adha',
                'date' => '2026-05-27',
                'is_recurring' => false,
                'month' => null,
                'day' => null,
            ],

        ];

        foreach ($holidays as $holiday) {
            Holiday::updateOrCreate(
                [
                    'name' => $holiday['name'],
                    'date' => $holiday['date'],
                ],
                $holiday
            );
        }
    }
}
