<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'first_name',
        'last_name',
        'other_names',
        'employee_number',
        'email',
        'phone_number',
        'gender',
        'date_of_birth',
        'department',
        'employment_status',
        'leave_status',
        'passport_photo',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    public function reports()
    {
        return $this->hasMany(Report::class);
    }

    public function payrolls()
    {
        return $this->hasMany(Payroll::class);
    }

    public function approvedPayrolls()
    {
        return $this->hasMany(Payroll::class, 'approved_by');
    }

    public function salesAndPurchases()
    {
        return $this->hasMany(SalesPurchaseRequest::class);
    }

    public function approvedSalesAndPurchases()
    {
        return $this->hasMany(SalesPurchaseRequest::class, 'approved_by');
    }

    public function attendances()
    {
        return $this->hasMany(Attendance::class);
    }

    public function leaveRequests()
    {
        return $this->hasMany(LeaveRequest::class);
    }

    public function leaveBalances()
    {
        return $this->hasMany(LeaveBalance::class);
    }

    public function approvedLeaves()
    {
        return $this->hasMany(LeaveRequest::class, 'approved_by');
    }

    protected static function booted()
    {
        static::creating(function ($user) {

            // Temporary placeholder to satisfy NOT NULL
            if (empty($user->employee_number)) {
                $user->employee_number = 'TEMP';
            }
        });

        static::created(function ($user) {

            // Now safely generate the final employee number
            $year = now()->format('y');
            $number = str_pad($user->id, 3, '0', STR_PAD_LEFT);

            $user->employee_number = "AON/{$year}{$number}";
            $user->saveQuietly();
        });
    }
}
