<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class UserManagementController extends Controller
{
    public function index()
    {
        return view('admin.users.index', [
            'users' => User::withTrashed()->latest()->get(),
            'user' => Auth::user()
        ]);
    }

    public function create()
    {
        return view('admin.users.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'first_name' => 'required',
            'last_name' => 'required',
            'email' => 'required|email|unique:users',
            'phone_number' => 'required',
            'gender' => 'required',
            'date_of_birth' => 'required|date',
            'department' => 'required',
        ]);

        $password = Str::random(10);

        $user = User::create([
            ...$data,
            'password' => Hash::make($password),
        ]);

        // Mail::raw(
        //     "Your account has been created.\n\nEmail: {$user->email}\nPassword: {$password}",
        //     fn ($m) => $m->to($user->email)->subject('Your Account Details')
        // );

        return redirect()->route('users.index')->with('success', 'User created successfully');
    }

    public function edit(User $user)
    {
        return view('admin.users.edit', compact('user'));
    }

    public function update(Request $request, User $user)
    {
        $data = $request->validate([
            'first_name' => 'required',
            'last_name' => 'required',
            'phone_number' => 'required',
            'department' => 'required',
        ]);

        $user->update($data);

        return back()->with('success', 'User updated successfully');
    }

    public function toggleStatus(User $user)
    {
        $user->employment_status = !$user->employment_status;
        $user->save();

        return back()->with('success', 'User status updated');
    }

    public function resetPassword(User $user)
    {
        $password = Str::random(10);

        $user->update([
            'password' => Hash::make($password)
        ]);

        // Mail::raw(
        //     "Your password has been reset.\n\nNew Password: {$password}",
        //     fn ($m) => $m->to($user->email)->subject('Password Reset')
        // );

        return back()->with('success', 'Password reset and emailed');
    }
}
