<?php

namespace App\Http\Controllers;

use App\Models\Report;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ReportController extends Controller
{
    public function submit(Request $request)
    {
        $request->validate([
            'type' => 'required|string|max:255',
            'remarks' => 'nullable|string',
            'file' => 'required|file|max:10240', // max 10MB
        ]);

        $filePath = $request->file('file')->store('reports', 'public');

        Report::create([
            'user_id' => Auth::id(),
            'type' => $request->type,
            'remarks' => $request->remarks,
            'file' => $filePath,
        ]);

        return redirect()->back()->with('success_report', 'Report submitted successfully!');
    }
}
