<?php

namespace App\Http\Controllers;

use App\Models\Payroll;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PayrollController extends Controller
{
    public function submit(Request $request)
    {
        $request->validate([
            'remarks' => 'nullable|string',
            'file' => 'required|file|max:10240', // max 10MB
        ]);

        $filePath = $request->file('file')->store('payrolls', 'public');

        Payroll::create([
            'user_id' => Auth::id(),
            'remarks' => $request->remarks,
            'file' => $filePath,
        ]);

        return redirect()->back()->with('success_report', 'Report submitted successfully!');
    }
}
