<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use App\Models\Attendance;
use App\Models\Report;
use App\Models\Payroll;
use App\Models\SalesPurchaseRequest;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();

        // Today's attendance
        $attendance = Attendance::where('user_id', $user->id)
            ->whereDate('created_at', today())
            ->first();

        // Attendance history
        $attendanceHistory = Attendance::where('user_id', $user->id)
            ->orderByDesc('created_at')
            ->limit(30)
            ->get();

        // Reports submitted by user
        $reports = Report::where('user_id', $user->id)
            ->orderByDesc('created_at')
            ->get();

        // Payroll submissions
        $payrolls = Payroll::where('user_id', $user->id)
            ->orderByDesc('created_at')
            ->get();

        // Sales & Purchase requests
        $salesRequests = SalesPurchaseRequest::where('user_id', $user->id)
            ->orderByDesc('created_at')
            ->get();

        return view('dashboard.index', compact(
            'user',
            'attendance',
            'attendanceHistory',
            'reports',
            'payrolls',
            'salesRequests'
        ));
    }
}
