<?php

namespace App\Http\Controllers;

use App\Models\Attendance;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AttendanceController extends Controller
{
    public function clockIn(Request $request)
    {
        $user = Auth::user();

        $attendance = Attendance::firstOrCreate(
            ['user_id' => $user->id, 'created_at' => now()->format('Y-m-d')],
            []
        );

        $attendance->update([
            'clock_in' => now()->format('H:i:s'),
            'clock_in_ip' => $request->ip(),
            'device' => $request->header('User-Agent'),
            'clock_in_lat' => $request->input('lat'),
            'clock_in_lng' => $request->input('lng'),
        ]);

        return redirect()->back()->with('success', 'Clocked in successfully!');
    }

    public function clockOut(Request $request)
    {
        $user = Auth::user();

        $attendance = Attendance::where('user_id', $user->id)
            ->whereDate('created_at', now())
            ->firstOrFail();

        $attendance->update([
            'clock_out' => now()->format('H:i:s'),
            'clock_out_ip' => $request->ip(),
            'clock_out_lat' => $request->input('lat'),
            'clock_out_lng' => $request->input('lng'),
        ]);

        return redirect()->back()->with('success', 'Clocked out successfully!');
    }

    
}
