<?php

namespace App\Http\Controllers;

use App\Models\Payroll;
use App\Models\LeaveBalance;
use App\Models\LeaveRequest;
use App\Models\SalesPurchaseRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminController extends Controller
{
        // Show all pending leave requests
    public function index()
    {
        // For simplicity, show all pending requests. You can filter by department if needed
        return view('admin.dashboard', [
            'leaveRequests' => LeaveRequest::where('status','pending')->with('user','leaveType')->get(),
            'payrolls' => Payroll::where('approved_by',NULL)->with('user')->get(),
            'sales' => SalesPurchaseRequest::where('approved_by',NULL)->with('user')->get(),
        ]);
    }

    public function action(Request $request)
    {
        $request->validate([
            'model' => 'required|string',
            'id' => 'required|integer',
            'status' => 'required|in:approved,declined',
        ]);

        $modelClass = match ($request->model) {
            'leave' => LeaveRequest::class,
            'payroll' => Payroll::class,
            'sales' => SalesPurchaseRequest::class,
        };

        $record = $modelClass::findOrFail($request->id);

        $record->status = $request->status;
        $record->approved_by = Auth::id();
        $record->save();

        // If approved, deduct the leave balance

        // Restore leave balance if declined
        if ($request->model === 'leave' && $request->status === 'approved') {
            LeaveBalance::where('user_id', $record->user_id)
                ->where('leave_type_id', $record->leave_type_id)
                ->decrement('balance_days', $record->total_days);
        }

        return back()->with('success', ucfirst($request->model).' '.$request->status.' successfully');
    }
}
